% Modified article class for KKIO'2000
%
% Copyright (C) 2000 Marek Kisiel-Dorohinicki

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{kkio}[2000/05/23 v0.2 Modified article class for KKIO'2000]

\LoadClass[a4paper,11pt,twoside]{article}

% paper size: B5 (W=17.5cm H=25cm) on A4 with 1.5cm (top&out) and 2cm margins

\setlength\textwidth{14cm}
\setlength\oddsidemargin{-1in}
\addtolength\oddsidemargin{5.5cm}
\setlength\evensidemargin{-1in}
\addtolength\evensidemargin{1.5cm}

\setlength\textheight{21.5cm}
\setlength\topmargin{-1in}
\addtolength\topmargin{1.5cm}
\setlength\headheight{0pt}
\setlength\headsep{0pt}

\pagestyle{empty}

\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \newpage\null
    \global\@topnum\z@   % Prevents figures from going at top of page.
    \vskip 7em%
    \begin{center}%
      \let \footnote \thanks
        {\LARGE\textbf{\@title}\par}%
        \vskip 1.5em%
        {\large
          \lineskip .5em%
          \begin{tabular}[t]{c}%
            \@author
          \end{tabular}\par}%
    \end{center}%
    \par
    \vskip 1.5em

    \thispagestyle{empty}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}

\renewcommand\thesection {\@arabic\c@section.}
\renewcommand\thesubsection   {\thesection\@arabic\c@subsection.}
\renewcommand\thesubsubsection{\thesubsection\@arabic\c@subsubsection.}
\renewcommand\theparagraph    {\thesubsubsection\@arabic\c@paragraph.}
\renewcommand\thesubparagraph {\theparagraph\@arabic\c@subparagraph.}

\bibliographystyle{plain}
